//
//	MBsysTran - Release 8.1
//
//	Copyright 
//	Universite catholique de Louvain (UCLouvain) 
//	Mechatronic, Electrical Energy, and Dynamic systems (MEED Division) 
//	2, Place du Levant
//	1348 Louvain-la-Neuve 
//	Belgium 
//
//	http://www.robotran.be 
//
//	==> Generation Date: Wed Oct  2 16:31:44 2024
//	==> using automatic loading with extension .mbs 
//
//	==> Project name: delta_fisette_c
//
//	==> Number of joints: 23
//
//	==> Function: F1 - Recursive Direct Dynamics of tree-like MBS
//
//	==> Git hash: 0cc862d03ff17d3428bf53a85358bd520952fe65
//
//	==> Input XML
//

#include <math.h> 

#include "mbs_data.h"

void mbs_dirdyna(double **M, double *c,
MbsData *s, double tsim)
{
#include "mbs_dirdyna_delta_fisette_c.h"

double *q, *qd;
double *g, *m;
double **l, **In, **dpt, **frc, **trq;

q = s->q;
qd = s->qd;

dpt = s->dpt;
l  = s->l;

m = s->m;
In = s->In;

frc = s->frc;
trq = s->trq;
g = s->g;
 
// Trigonometric functions

S4 = sin(q[4]);
C4 = cos(q[4]);
S5 = sin(q[5]);
C5 = cos(q[5]);
S6 = sin(q[6]);
C6 = cos(q[6]);
S7 = sin(q[7]);
C7 = cos(q[7]);
S8 = sin(q[8]);
C8 = cos(q[8]);
S9 = sin(q[9]);
C9 = cos(q[9]);
S10 = sin(q[10]);
C10 = cos(q[10]);
S11 = sin(q[11]);
C11 = cos(q[11]);
S12 = sin(q[12]);
C12 = cos(q[12]);
S13 = sin(q[13]);
C13 = cos(q[13]);
S14 = sin(q[14]);
C14 = cos(q[14]);
S15 = sin(q[15]);
C15 = cos(q[15]);
S16 = sin(q[16]);
C16 = cos(q[16]);
S17 = sin(q[17]);
C17 = cos(q[17]);
S18 = sin(q[18]);
C18 = cos(q[18]);
S19 = sin(q[19]);
C19 = cos(q[19]);
S20 = sin(q[20]);
C20 = cos(q[20]);
S21 = sin(q[21]);
C21 = cos(q[21]);
S22 = sin(q[22]);
C22 = cos(q[22]);
S23 = sin(q[23]);
C23 = cos(q[23]);
S15p16 = C15*S16+S15*C16;
C15p16 = C15*C16-S15*S16;
S20p21 = C20*S21+S20*C21;
C20p21 = C20*C21-S20*S21;
 
// Forward Kinematics

 
// Backward Dynamics

FF121 = -frc[1][21]-frc[1][22]-frc[1][23];
FF221 = -frc[2][21]-frc[2][22]*C22-frc[2][23]*C23+frc[3][22]*S22+frc[3][23]*S23;
FF321 = -frc[3][21]-frc[2][22]*S22-frc[2][23]*S23-frc[3][22]*C22-frc[3][23]*C23;
CF121 = -trq[1][21]-trq[1][22]-trq[1][23]+dpt[2][20]*(-frc[2][22]*S22-frc[3][22]*C22)+dpt[2][21]*(-frc[2][23]*S23-
 frc[3][23]*C23);
CF221 = -trq[2][21]-trq[2][22]*C22-trq[2][23]*C23+trq[3][22]*S22+trq[3][23]*S23;
CF321 = -trq[3][21]+frc[1][22]*dpt[2][20]+frc[1][23]*dpt[2][21]-trq[2][22]*S22-trq[2][23]*S23-trq[3][22]*C22-
 trq[3][23]*C23;
CF120 = -trq[1][20]+CF121*C21+CF321*S21-FF221*dpt[3][19];
CF220 = -trq[2][20]+CF221+dpt[3][19]*(FF121*C21+FF321*S21);
CF320 = -trq[3][20]-CF121*S21+CF321*C21;
CF319 = -CF120*S20+CF320*C20;
FF116 = -frc[1][16]-frc[1][17]-frc[1][18];
FF216 = -frc[2][16]-frc[2][17]*C17-frc[2][18]*C18+frc[3][17]*S17+frc[3][18]*S18;
FF316 = -frc[3][16]-frc[2][17]*S17-frc[2][18]*S18-frc[3][17]*C17-frc[3][18]*C18;
CF116 = -trq[1][16]-trq[1][17]-trq[1][18]+dpt[2][16]*(-frc[2][17]*S17-frc[3][17]*C17)+dpt[2][17]*(-frc[2][18]*S18-
 frc[3][18]*C18);
CF216 = -trq[2][16]-trq[2][17]*C17-trq[2][18]*C18+trq[3][17]*S17+trq[3][18]*S18;
CF316 = -trq[3][16]+frc[1][17]*dpt[2][16]+frc[1][18]*dpt[2][17]-trq[2][17]*S17-trq[2][18]*S18-trq[3][17]*C17-
 trq[3][18]*C18;
CF115 = -trq[1][15]+CF116*C16+CF316*S16-FF216*dpt[3][15];
CF215 = -trq[2][15]+CF216+dpt[3][15]*(FF116*C16+FF316*S16);
CF315 = -trq[3][15]-CF116*S16+CF316*C16;
CF314 = -CF115*S15+CF315*C15;
FF111 = -frc[1][11]-frc[1][12]-frc[1][13];
FF311 = -frc[3][11]-frc[2][12]*S12-frc[2][13]*S13-frc[3][12]*C12-frc[3][13]*C13;
CF211 = -trq[2][11]-trq[2][12]*C12-trq[2][13]*C13+trq[3][12]*S12+trq[3][13]*S13;
CF210 = -trq[2][10]+CF211+dpt[3][11]*(FF111*C11+FF311*S11);
FF18 = -frc[1][9]*C9-frc[3][9]*S9;
FF38 = frc[1][9]*S9-frc[3][9]*C9;
CF38 = trq[1][9]*S9-trq[3][9]*C9;
FF16 = -frc[1][7]*C7-frc[3][7]*S7;
FF36 = frc[1][7]*S7-frc[3][7]*C7;
CF36 = trq[1][7]*S7-trq[3][7]*C7;
FF14 = -frc[1][5]*C5-frc[3][5]*S5;
FF34 = frc[1][5]*S5-frc[3][5]*C5;
CF34 = trq[1][5]*S5-trq[3][5]*C5;
FA33 = -frc[3][3]-m[3]*g[3];
FF13 = -frc[1][3]+frc[2][5]*S4+frc[2][7]*S6+frc[2][9]*S8+FF14*C4+FF16*C6+FF18*C8;
FF23 = -frc[2][3]-frc[2][5]*C4-frc[2][7]*C6-frc[2][9]*C8+FF14*S4+FF16*S6+FF18*S8;
FF33 = FA33+FF34+FF36+FF38;
 
// Symbolic model output

c[1] = FF13;
c[2] = FF23;
c[3] = FF33;
c[4] = CF34;
c[5] = -trq[2][5];
c[6] = CF36;
c[7] = -trq[2][7];
c[8] = CF38;
c[9] = -trq[2][9];
c[10] = CF210;
c[11] = CF211;
c[12] = -trq[1][12];
c[13] = -trq[1][13];
c[14] = CF314;
c[15] = CF215;
c[16] = CF216;
c[17] = -trq[1][17];
c[18] = -trq[1][18];
c[19] = CF319;
c[20] = CF220;
c[21] = CF221;
c[22] = -trq[1][22];
c[23] = -trq[1][23];
M[1][1] = m[3];
M[2][2] = m[3];
M[3][3] = m[3];

// Number of continuation lines = 1

}
